<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_menu
 *
 * @copyright   (C) 2020 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Filter\OutputFilter;
use Joomla\CMS\HTML\HTMLHelper;

$attributes = [];

if ($item->anchor_title)
{
	$attributes['title'] = $item->anchor_title;
}

if ($item->deeper)
{
	$attributes['data|toggle'] = 'dropdown'; 
	//$item->anchor_css = 'dropdown-toggle';
}
if ($item->anchor_css)
{
	$attributes['class'] = $item->anchor_css;
}
$attributes['class'] =  'nav-link pagescroll ';
if ($item->anchor_rel)
{
	$attributes['rel'] = $item->anchor_rel;
}   
if (in_array($item->id, $path))
{
	$attributes['class'] = 'active'; 
}
elseif ($item->type === 'alias')
{
	$aliasToId = $itemParams->get('aliasoptions');

	if (count($path) > 0 && $aliasToId == $path[count($path) - 1])
	{
		$attributes['class'] = 'active'; 
	}
	elseif (in_array($aliasToId, $path))
	{
		$attributes['class'] = 'alias-parent-active';
	}
}
$linktype = $item->title;

if ($item->menu_image)
{
	$linktype = HTMLHelper::image($item->menu_image, $item->title);

	if ($item->menu_image_css)
	{
		$image_attributes['class'] = $item->menu_image_css;
		$linktype                  = HTMLHelper::image($item->menu_image, $item->title, $image_attributes);
	}

	if ($itemParams->get('menu_text', 1))
	{
		$linktype .= '<span class="image-title">' . $item->title . '</span>';
	}
}

if ($item->browserNav == 1)
{
	$attributes['target'] = '_blank';
	$attributes['rel']    = 'noopener noreferrer';

	if ($item->anchor_rel == 'nofollow')
	{
		$attributes['rel'] .= ' nofollow';
	}
}
elseif ($item->browserNav == 2)
{
	$options = 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,' . $params->get('window_open');

	$attributes['onclick'] = "window.open(this.href, 'targetWindow', '" . $options . "'); return false;";
}

echo HTMLHelper::link(OutputFilter::ampReplace(htmlspecialchars($item->flink, ENT_COMPAT, 'UTF-8', false)), $linktype, $attributes);
 
