<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_category
 *
 * @copyright   (C) 2010 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;

if (!$list)
{
	return;
}  
?>
<div class="studies-area section-padding">
	<div class="container-fluid">
		<div class="col-l2">
			<div class="section-title section-title2 text-center">
				<span><?php echo $params->get('bt_subtitle');?></span>
				<h2><?php echo $module->title;?></h2>
			</div>
		</div>
		<div class="col-12">
			<div class="studies-menu text-center">
				<button class="active" data-filter="*">All</button>
				<?php if ($params->get('show_tags')): ?>
					<?php 
						$bt_tags = array();
						foreach ($list as $item) : 
							foreach($item->tags->itemTags as $item_tag){
								$bt_tags[$item_tag->alias] = $item_tag->title;
							} 
						endforeach; 
					?> 
					   <?php foreach ($bt_tags as $tag_alias=>$tag_title) : ?>
							<button data-filter=".<?php echo $tag_alias;?>"><?php echo $tag_title;?></button> 
						<?php endforeach;  ?>  
					<?php endif; ?> 
			</div>
		</div> 
		 
		<div class="row grid">
			<?php if ($grouped) :  ?>
				<?php foreach ($list as $groupName => $items) : ?>
				 
						<?php require ModuleHelper::getLayoutPath('mod_cb_articles', $params->get('layout', 'default') . '_items'); ?> 
				<?php endforeach; ?>
			<?php else : ?>
				<?php $items = $list; ?>
				<?php require ModuleHelper::getLayoutPath('mod_cb_articles', $params->get('layout', 'default') . '_items'); ?>
			<?php endif; ?> 
			 
		</div> 
	</div> 
</div>

