<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Associations;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;
use Joomla\Component\Content\Site\Helper\RouteHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

// Create a shortcut for params.
$params = $this->item->params;
$canEdit = $this->item->params->get('access-edit');
$info    = $params->get('info_block_position', 0);

// Check if associations are implemented. If they are, define the parameter.
$assocParam = (Associations::isEnabled() && $params->get('show_associations'));

$currentDate   = Factory::getDate()->format('Y-m-d H:i:s');
$isUnpublished = ($this->item->state == ContentComponent::CONDITION_UNPUBLISHED || $this->item->publish_up > $currentDate)
	|| ($this->item->publish_down < $currentDate && $this->item->publish_down !== null);

$bt_image_intro = json_decode( $this->item->images)->image_intro;
$bt_image_fulltext = json_decode( $this->item->images)->image_fulltext;
?>
 <?php if ($params->get('show_readmore') && $this->item->readmore) :
		if ($params->get('access-view')) :
			$link = Route::_(RouteHelper::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language));
		else :
			$menu = Factory::getApplication()->getMenu();
			$active = $menu->getActive();
			$itemId = $active->id;
			$link = new Uri(Route::_('index.php?option=com_users&view=login&Itemid=' . $itemId, false));
			$link->setVar('return', base64_encode(RouteHelper::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language)));
		endif;endif; ?> 

<div class=" ">
	<div class="blog-img">
	   <div class="blog-s2">
		   <img src="<?php echo $bt_image_intro;?>" alt="<?php echo $this->item->title;?>">
	   </div>
		<ul class="post-meta">  
			<li> <?php
			echo HTMLHelper::_(
				'date', $this->item->displayDate,
				$this->escape($this->params->get('date_format', Text::_('d M Y')))
			); ?></li>
		</ul>
   </div>
   <div class="blog-content-2">
	   <?php if ($params->get('show_title')) : ?>
	  <h2><?php echo $this->escape($this->item->title); ?></h2>
	  <?php endif; ?> 
	   <?php if ($this->params->get('show_category_introtext', 1)) : ?> 
				<?php echo $this->item->introtext; ?>
				<?php endif; ?>
	   <a href="<?php echo Route::_(RouteHelper::getArticleRoute($this->item->slug, $this->item->catid, $this->item->language));?>"><?php echo Text::_('COM_CONTENT_FEED_READMORE');?></a>
   </div>
	  
	 
	 
	<?php if ($isUnpublished) : ?>
		<div class="system-unpublished">
	<?php endif; ?>
 
	<?php if ($canEdit) : ?>
		<?php echo LayoutHelper::render('joomla.content.icons', array('params' => $params, 'item' => $this->item)); ?>
	<?php endif; ?>

	 
	<?php if (!$params->get('show_intro')) : ?>
		<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
		<?php echo $this->item->event->afterDisplayTitle; ?>
	<?php endif; ?>

	<?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
	<?php echo $this->item->event->beforeDisplayContent; ?>
 
 

	<?php if ($isUnpublished) : ?>
		</div>
	<?php endif; ?>

	<?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
	<?php echo $this->item->event->afterDisplayContent; ?>
</div>
